﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls.Survey
{
    public partial class SurveyQuestionCalculation : BaseControl
    {
        public List<SURVEY_RESULTS> Questions { get; set; }
        public List<SURVEY_RESULTS> Results { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
        }

        public void BuildQuestion()
        {
            SURVEY_RESULTS question = Questions.First();
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            if (question != null)
            {
                hidResultId.Value = question.SURVEY_RESULT_ID.ToString();
            }

            //lblQuestion.ID = "lbl" + stdQuestion.ID.ToString();
            if (!string.IsNullOrEmpty(AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER)))
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER) + ") " + AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);
            else
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);

            //if (question != null)
            //{
            //    if (!string.IsNullOrWhiteSpace(stdQuestion.UNIT_HINT))
            //    {
            //        lblUnitHint.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.UNIT_HINT);
            //    }
            //    txtResponse.ID = "txt" + question.SURVEY_RESULT_ID.ToString();
            //    txtResponse.ToolTip = "Enter a value for Question " + stdQuestion.QUESTION_NUMBER;

            //    if (!Page.IsPostBack)
            //        txtResponse.Text = question.RESULT_TEXT;
            //    else
            //    {
            //        if (Request != null && Request.Form != null && Request.Form["ctl00$MainContent$" + txtResponse.ID] != null)
            //            txtResponse.Text = Request.Form["ctl00$MainContent$" + txtResponse.ID].ToString();
            //    }
            //}
        }

        public string BuildNoteTemplate()
        {
            StringBuilder sbNote = new StringBuilder();

            SURVEY_RESULTS question = Questions.First();
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            if (!string.IsNullOrEmpty(stdQuestion.QUESTION_NUMBER))
            {
                string strQuestion = stdQuestion.QUESTION_NUMBER + ") " + stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine(strQuestion);
            }
            else
            {
                string strQuestion = stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine(strQuestion);
            }

            if (question != null && !string.IsNullOrWhiteSpace(question.RESULT_TEXT))
            {
                string unitHint = "";
                if (!string.IsNullOrWhiteSpace(stdQuestion.UNIT_HINT))
                {
                    unitHint = " " + AntiXssEnc.Encoder.HtmlEncode(stdQuestion.UNIT_HINT);
                }
                sbNote.AppendLine("- " + question.RESULT_TEXT + unitHint);
            }

            return sbNote.ToString();
        }

        public void SaveQuestion()
        {
            int resultId = 0;
            if (int.TryParse(hidResultId.Value, out resultId))
            {
                foreach (SURVEY_RESULTS result in Results)
                {
                    if (result.SURVEY_RESULT_ID == resultId)
                    {
                        CalculateResult(result);
                    }
                }
            }
        }

        public void CalculateResult(SURVEY_RESULTS result)
        {
            STD_REGISTRY r = ServiceInterfaceManager.STD_REGISTRY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, UserSession.CurrentRegistryId);

            //Only look at EXTERNAL_DATA_ID within the specific Registry Code
            switch (r.CODE) {
                case "AR":
                    {
                        //QuickDASH score
                        if (result.STD_QUESTION.EXTERNAL_DATA_ID == 2000)
                        {
                            double total = 0;
                            int QDCount = 0;
                            double score = 0;

                            var codes = new List<int>() { 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011 };
                            var surveyResults = Results.Where(x => codes.Contains(x.STD_QUESTION.EXTERNAL_DATA_ID.HasValue ? x.STD_QUESTION.EXTERNAL_DATA_ID.Value : 0));
                            foreach (var surveyResult in surveyResults)
                            {
                                if (surveyResult.SELECTED_FLAG)
                                {
                                    int choiceValue = 0;
                                    if (int.TryParse(surveyResult.STD_QUESTION_CHOICE.CHOICE_NAME, out choiceValue))
                                    {
                                        QDCount++;
                                        total += choiceValue;
                                    }
                                }
                            }

                            score = Math.Round(((total / QDCount) - 1) * 25);
                            result.RESULT_TEXT = Convert.ToString(score);
                        }
                        //Amputee Single Item Mobility Measure (AMPSIMM) Score
                        else if (result.STD_QUESTION.EXTERNAL_DATA_ID == 100)
                        {
                            double total = 0;
                            int QDCount = 0;
                            double score = 0;

                            var codes = new List<int>() { 101 };
                            var surveyResults = Results.Where(x => codes.Contains(x.STD_QUESTION.EXTERNAL_DATA_ID.HasValue ? x.STD_QUESTION.EXTERNAL_DATA_ID.Value : 0));
                            foreach (var surveyResult in surveyResults)
                            {
                                if (surveyResult.SELECTED_FLAG)
                                {
                                    int choiceValue = 0;
                                    if (int.TryParse(surveyResult.STD_QUESTION_CHOICE.CHOICE_NAME, out choiceValue))
                                    {
                                        QDCount++;
                                        total += choiceValue;
                                    }
                                }
                            }

                            score = total;
                            result.RESULT_TEXT = Convert.ToString(score);
                        }
                        else if (result.STD_QUESTION.EXTERNAL_DATA_ID == 3000)
                        {
                            //PLUS-M
                            int total = 0;
                            int numQuestionsAnswered = 0;
                            double score = 0;

                            var codes = new List<int>() { 3001, 3002, 3003, 3004, 3005, 3006, 3007, 3008, 3009, 3010, 3011, 3012 };
                            var surveyResults = Results.Where(x => codes.Contains(x.STD_QUESTION.EXTERNAL_DATA_ID.HasValue ? x.STD_QUESTION.EXTERNAL_DATA_ID.Value : 0));
                            foreach (var surveyResult in surveyResults)
                            {
                                if (surveyResult.SELECTED_FLAG)
                                {
                                    int choiceValue = 0;
                                    if (int.TryParse(surveyResult.STD_QUESTION_CHOICE.CHOICE_NAME, out choiceValue))
                                    {
                                        numQuestionsAnswered++;
                                        total += choiceValue;
                                    }
                                }
                            }

                            if (total != 0)
                            {
                                score = GetPlusMScore(total);
                                result.RESULT_TEXT = Convert.ToString(score);
                            }
                            else
                            {
                                result.RESULT_TEXT = null;
                            }
                        }
                        else if (result.STD_QUESTION.EXTERNAL_DATA_ID == 1000)
                        {
                            //CHAMP
                            double score = 0;
                            int choiceValue = 0;

                            var surveyResultSls = Results.Where(x => x.STD_QUESTION.EXTERNAL_DATA_ID == 1001).SingleOrDefault();
                            choiceValue = 0;
                            if (int.TryParse(surveyResultSls.RESULT_TEXT, out choiceValue))
                            {
                                score += GetCHAMPScore(choiceValue, ChampTest.SLS);
                            }
                            var surveyResultEss = Results.Where(x => x.STD_QUESTION.EXTERNAL_DATA_ID == 1002).SingleOrDefault();
                            choiceValue = 0;
                            if (int.TryParse(surveyResultEss.RESULT_TEXT, out choiceValue))
                            {
                                score += GetCHAMPScore(choiceValue, ChampTest.ESS);
                            }
                            var surveyResultTt = Results.Where(x => x.STD_QUESTION.EXTERNAL_DATA_ID == 1003).SingleOrDefault();
                            choiceValue = 0;
                            if (int.TryParse(surveyResultTt.RESULT_TEXT, out choiceValue))
                            {
                                score += GetCHAMPScore(choiceValue, ChampTest.TT);
                            }
                            var surveyResultIat = Results.Where(x => x.STD_QUESTION.EXTERNAL_DATA_ID == 1004).SingleOrDefault();
                            choiceValue = 0;
                            if (int.TryParse(surveyResultIat.RESULT_TEXT, out choiceValue))
                            {
                                score += GetCHAMPScore(choiceValue, ChampTest.IAT);
                            }

                            result.RESULT_TEXT = Convert.ToString(score);
                        }
                        break;
                    }
            }
        }

        private double GetPlusMScore(int rawScore)
        {
            Dictionary<int, double> items = new Dictionary<int, double>();
            items.Add(12, 21.8);
            items.Add(13, 25.2);
            items.Add(14, 27.2);
            items.Add(15, 28.7);
            items.Add(16, 30);
            items.Add(17, 31.2);
            items.Add(18, 32.2);
            items.Add(19, 33.2);
            items.Add(20, 34.1);
            items.Add(21, 34.9);
            items.Add(22, 35.6);
            items.Add(23, 36.4);
            items.Add(24, 37.1);
            items.Add(25, 37.7);
            items.Add(26, 38.4);
            items.Add(27, 39);
            items.Add(28, 39.7);
            items.Add(29, 40.3);
            items.Add(30, 40.9);
            items.Add(31, 41.5);
            items.Add(32, 42.1);
            items.Add(33, 42.7);
            items.Add(34, 43.3);
            items.Add(35, 43.9);
            items.Add(36, 44.5);
            items.Add(37, 45.2);
            items.Add(38, 45.8);
            items.Add(39, 46.4);
            items.Add(40, 47.1);
            items.Add(41, 47.7);
            items.Add(42, 48.4);
            items.Add(43, 49.1);
            items.Add(44, 49.8);
            items.Add(45, 50.5);
            items.Add(46, 51.2);
            items.Add(47, 52);
            items.Add(48, 52.7);
            items.Add(49, 53.6);
            items.Add(50, 54.4);
            items.Add(51, 55.3);
            items.Add(52, 56.3);
            items.Add(53, 57.3);
            items.Add(54, 58.4);
            items.Add(55, 59.6);
            items.Add(56, 61);
            items.Add(57, 62.5);
            items.Add(58, 64.5);
            items.Add(59, 67.1);
            items.Add(60, 71.4);

            var tScore = items[rawScore];

            return tScore;
        }

        private enum ChampTest
        {
            SLS = 1,
            ESS = 2,
            TT = 3,
            IAT = 4
        }

        private double GetCHAMPScore(int rawScore, ChampTest type)
        {
            double testScore = 0;

            switch (type)
            {
                case ChampTest.SLS:
                    if (rawScore == 0)
                        testScore = 0;
                    else if (rawScore >= .1 && rawScore <= 3.3)
                        testScore = .5;
                    else if (rawScore >= 3.4 && rawScore <= 6.6)
                        testScore = 1;
                    else if (rawScore >= 6.7 && rawScore <= 10.0)
                        testScore = 1.5;
                    else if (rawScore >= 10.1 && rawScore <= 13.3)
                        testScore = 2;
                    else if (rawScore >= 13.4 && rawScore <= 16.6)
                        testScore = 2.5;
                    else if (rawScore >= 16.7 && rawScore <= 19.9)
                        testScore = 3;
                    else if (rawScore >= 20 && rawScore <= 23.2)
                        testScore = 3.5;
                    else if (rawScore >= 3.4 && rawScore <= 26.5)
                        testScore = 4;
                    else if (rawScore >= 3.4 && rawScore <= 29.8)
                        testScore = 4.5;
                    else if (rawScore >= 3.4 && rawScore <= 33.1)
                        testScore = 5;
                    else if (rawScore >= 3.4 && rawScore <= 36.4)
                        testScore = 5.5;
                    else if (rawScore >= 3.4 && rawScore <= 39.7)
                        testScore = 6;
                    else if (rawScore >= 3.4 && rawScore <= 43)
                        testScore = 6.5;
                    else if (rawScore >= 3.4 && rawScore <= 46.3)
                        testScore = 7;
                    else if (rawScore >= 3.4 && rawScore <= 49.6)
                        testScore = 7.5;
                    else if (rawScore >= 3.4 && rawScore <= 52.9)
                        testScore = 8;
                    else if (rawScore >= 3.4 && rawScore <= 56.2)
                        testScore = 8.5;
                    else if (rawScore >= 3.4 && rawScore <= 59.5)
                        testScore = 9;
                    else if (rawScore >= 3.4 && rawScore <= 6.6)
                        testScore = 10;

                    break;
                case ChampTest.ESS:
                    if (rawScore < 5)
                        testScore = 0;
                    else if (rawScore >= 5 && rawScore <= 7)
                        testScore = 1;
                    else if (rawScore >= 8 && rawScore <= 10)
                        testScore = 2;
                    else if (rawScore >= 11 && rawScore <= 13)
                        testScore = 3;
                    else if (rawScore >= 14 && rawScore <= 16)
                        testScore = 4;
                    else if (rawScore >= 17 && rawScore <= 19)
                        testScore = 5;
                    else if (rawScore >= 20 && rawScore <= 22)
                        testScore = 6;
                    else if (rawScore >= 23 && rawScore <= 25)
                        testScore = 7;
                    else if (rawScore >= 26 && rawScore <= 28)
                        testScore = 8;
                    else if (rawScore >= 29 && rawScore <= 31)
                        testScore = 9;
                    else if (rawScore >= 32)
                        testScore = 10;

                    break;
                case ChampTest.TT:
                    if (rawScore > 124)
                        testScore = 0;
                    else if (rawScore >= 50.7 && rawScore <= 123.9)
                        testScore = 1;
                    else if (rawScore >= 45.7 && rawScore <= 50.6)
                        testScore = 2;
                    else if (rawScore >= 40.8 && rawScore <= 45.6)
                        testScore = 3;
                    else if (rawScore >= 36.0 && rawScore <= 40.7)
                        testScore = 4;
                    else if (rawScore >= 31.1 && rawScore <= 35.9)
                        testScore = 5;
                    else if (rawScore >= 26.2 && rawScore <= 31)
                        testScore = 6;
                    else if (rawScore >= 21.3 && rawScore <= 26.1)
                        testScore = 7;
                    else if (rawScore >= 16.5 && rawScore <= 21.2)
                        testScore = 8;
                    else if (rawScore >= 11.6 && rawScore < 16.4)
                        testScore = 9;
                    else if (rawScore < 11.6)
                        testScore = 10;

                    break;
                case ChampTest.IAT:
                    if (rawScore > 65.4)
                        testScore = 0;
                    else if (rawScore >= 60 && rawScore <= 65.4)
                        testScore = 1;
                    else if (rawScore >= 54.5 && rawScore <= 59.9)
                        testScore = 2;
                    else if (rawScore >= 49.0 && rawScore <= 54.4)
                        testScore = 3;
                    else if (rawScore >= 43.5 && rawScore <= 48.9)
                        testScore = 4;
                    else if (rawScore >= 38.0 && rawScore <= 43.4)
                        testScore = 5;
                    else if (rawScore >= 32.5 && rawScore <= 37.9)
                        testScore = 6;
                    else if (rawScore >= 27.0 && rawScore <= 32.4)
                        testScore = 7;
                    else if (rawScore >= 21.5 && rawScore <= 26.9)
                        testScore = 8;
                    else if (rawScore >= 15.9 && rawScore < 21.4)
                        testScore = 9;
                    else if (rawScore < 15.9)
                        testScore = 10;

                    break;
            }

            return testScore;
        }
    }
}